*Here is replication code in Stata for O'Dwyer and Stenberg (2021), "Local-Level Democratic Backsliding?", Government and Opposition. This file will replicate Table 4 and Figures 3 and 4 in text, 
*as well as Appendices A-E. Figures 1 and 2 use separate data from V-Dem, and replication code (and data) are available in separate files in this ZIP. The top section replicates pre-processing
*and must be skipped if you are using the enclosed .dta file. We have removed unused variables from our original CSV data for the replication data. The original CSV can be made available on request.

*set more off

*SKIP THIS SECTION IF YOU ARE WORKING FROM THE STATA.DAT FILE INSTEAD OF THE .CSV
*drop missing data/NAs
*ds, has(type string)
*foreach var of varlist `r(varlist)' {
*	replace `var' = "" if (`var'=="MS"|`var'=="NA"|`var'=="AVG"|`var'=="#VALUE!")
*}

*destring, replace

*create panel id variable
*egen double cidnew = group(city)

*gen pis_second_round_win=1 if round_2==1 & dom_party_overall_win==1
*replace pis_second_round_win=0 if dom_party_cand==1 & round_2==1 & missing(pis_second_round_win)

*replace popscaled = population/10000

**OK START HERE**
*Import the Stata .dat file from your relevant location

set more off

graph set window fontface "Times New Roman"

xtset cidnew cycle_year

*TABLE 4 MODELS -- ODDS RATIOS* -- logistic regression coefficients are below in Appendix A.
*This code for odds ratios only works with Stata 15 and above. If you run it in Stata 14, you will get standard coefficients (same as Appendix A). 
set more off 

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand i.cycle_year if country==1, re or
estimates store table5model1or

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand i.cycle_year if country==2, re or
estimates store table5model2or

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand i.cycle_year i.country, re or
estimates store table5model3or

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year if country==1, re or
estimates store table5model4or

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year if country==2, re or
estimates store table5model5or

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year i.country, re or
estimates store table5model6or

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand i.cycle_year, re or
estimates store table5model7or

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand dom_party_inc_cand i.cycle_year, re or
estimates store table5model8or

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year if round_2==1, re or
estimates store table5model9or

esttab table5model1or table5model2or table5model3or table5model4or table5model5or table5model6or table5model7or table5model8or table5model9or, compress coeflabels(unemployment_rate Unemployment numbercand Candidates percent_over_sixty Percent over Sixty logpop Population) se label nonumbers nodepvars mtitles("Model 1" "Model 2" "Model 3" "Model 4" "Model 5" "Model 6" "Model 7" "Model 8" "Model 9") onecell nogap, using GO_Final_Table_4_Odds_Ratios.rtf, replace title({\b Table 4.} {Likelihood of Dominant party winning})

*Appendix A - Logistic Regression Coefficients*

set more off 

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand i.cycle_year if country==1
estimates store table5model1

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand i.cycle_year if country==2
estimates store table5model2

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand i.cycle_year i.country
estimates store table5model3

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year if country==1
estimates store table5model4

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year if country==2
estimates store table5model5

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year i.country
estimates store table5model6

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand i.cycle_year 
estimates store table5model7

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand dom_party_inc_cand i.cycle_year 
estimates store table5model8

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year if round_2==1
estimates store table5model9

esttab table5model1 table5model2 table5model3 table5model4 table5model5 table5model6 table5model7 table5model8 table5model9, compress coeflabels(unemployment_rate Unemployment numbercand Candidates percent_over_sixty Percent over Sixty logpop Population) se label nonumbers nodepvars mtitles("Model 1" "Model 2" "Model 3" "Model 4" "Model 5" "Model 6" "Model 7" "Model 8" "Model 9") onecell nogap, using GO_Final_Appendix_A.rtf, replace title({\b Table A.} {Likelihood of Dominant party winning})

**APPENDIX B -- SUBURBS AS DUMMY INCLUSION
set more off

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand FUA_Suburb i.cycle_year if country==1
estimates store table5model1sub

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand FUA_Suburb i.cycle_year if country==2
estimates store table5model2sub

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand FUA_Suburb i.cycle_year i.country
estimates store table5model3sub

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand FUA_Suburb i.cycle_year if country==1
estimates store table5model4sub

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand FUA_Suburb i.cycle_year if country==2
estimates store table5model5sub

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand FUA_Suburb i.cycle_year i.country
estimates store table5model6sub

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand FUA_Suburb i.cycle_year 
estimates store table5model7sub

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand dom_party_inc_cand FUA_Suburb i.cycle_year 
estimates store table5model8sub

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand FUA_Suburb i.cycle_year if round_2==1
estimates store table5model9sub

esttab table5model1sub table5model2sub table5model3sub table5model4sub table5model5sub table5model6sub table5model7sub table5model8sub table5model9sub, compress coeflabels(unemployment_rate Unemployment numbercand Candidates percent_over_sixty Percent over Sixty logpop Population) se label nonumbers nodepvars mtitles("Model 1" "Model 2" "Model 3" "Model 4" "Model 5" "Model 6" "Model 7" "Model 8" "Model 9") onecell nogap, using GO_Final_Appendix_B.rtf, replace title({\b Table B.} {Likelihood of Dominant party winning})

**APPENDIX C -- VIABLE CANDIDATES
*In our paper, we use a 10% threshold for viability. Our replication data also includes variables for candidates over alternative thresholds for viability (5% and 15%) for comparisons
set more off

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty viable_cand_over_10 dom_party_inc_cand i.cycle_year if country==1
estimates store table5model410

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty viable_cand_over_10 dom_party_inc_cand i.cycle_year if country==2
estimates store table5model510

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty viable_cand_over_10 dom_party_inc_cand i.cycle_year i.country
estimates store table5model610

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.viable_cand_over_10 i.cycle_year 
estimates store table5model710

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.viable_cand_over_10 dom_party_inc_cand i.cycle_year 
estimates store table5model810

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty viable_cand_over_10 dom_party_inc_cand i.cycle_year if round_2==1
estimates store table5model910

esttab table5model1 table5model2 table5model3 table5model410 table5model510 table5model610 table5model710 table5model810 table5model910, compress coeflabels(unemployment_rate Unemployment numbercand Candidates percent_over_sixty Percent over Sixty logpop Population) se label nonumbers nodepvars mtitles("Model 1" "Model 2" "Model 3" "Model 4" "Model 5" "Model 6" "Model 7" "Model 8" "Model 9") onecell nogap, using GO_Final_Appendix_C.rtf, replace title({\b Table C.} {Likelihood of Dominant party winning})

*APPENDIX D -- CITY COUNCIL ELECTION THRESHOLDS*
*The first configuration, Table D1, dropping cities below the council list electoral threshold (10,000 in Hungary, 20,000 in Poland) from the data and rerunning models.
set more off 
preserve
drop if pop_greater_than_electoral_list_==0

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand i.cycle_year if country==1
estimates store table5model1big

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand i.cycle_year if country==2
estimates store table5model2big

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand i.cycle_year i.country
estimates store table5model3big

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year if country==1
estimates store table5model4big

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year if country==2
estimates store table5model5big

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year i.country
estimates store table5model6big

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand i.cycle_year 
estimates store table5model7big

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand dom_party_inc_cand i.cycle_year 
estimates store table5model8big

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year if round_2==1
estimates store table5model9big

esttab table5model1big table5model2big table5model3big table5model4big table5model5big table5model6big table5model7big table5model8big table5model9big, compress coeflabels(unemployment_rate Unemployment numbercand Candidates percent_over_sixty Percent over Sixty logpop Population) se label nonumbers nodepvars mtitles("Model 1" "Model 2" "Model 3" "Model 4" "Model 5" "Model 6" "Model 7" "Model 8" "Model 9") onecell nogap, using GO_Final_Appendix_D1.rtf, replace title({\b Table D1.} {Likelihood of Dominant party winning})

restore

*A second configuration, Table D2, the population threshold as a dummy variable*
set more off

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand pop_greater_than_electoral_list_ i.cycle_year if country==1
estimates store table5model1cc

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand pop_greater_than_electoral_list_ i.cycle_year if country==2
estimates store table5model2cc

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand pop_greater_than_electoral_list_ i.cycle_year i.country
estimates store table5model3cc

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand pop_greater_than_electoral_list_ i.cycle_year if country==1
estimates store table5model4cc

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand pop_greater_than_electoral_list_ i.cycle_year if country==2
estimates store table5model5cc

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand pop_greater_than_electoral_list_ i.cycle_year i.country
estimates store table5model6cc

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand pop_greater_than_electoral_list_ i.cycle_year 
estimates store table5model7cc

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand dom_party_inc_cand pop_greater_than_electoral_list_ i.cycle_year 
estimates store table5model8cc

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand pop_greater_than_electoral_list_ i.cycle_year if round_2==1
estimates store table5model9cc

esttab table5model1cc table5model2cc table5model3cc table5model4cc table5model5cc table5model6cc table5model7cc table5model8cc table5model9cc, compress coeflabels(unemployment_rate Unemployment numbercand Candidates percent_over_sixty Percent over Sixty logpop Population) se label nonumbers nodepvars mtitles("Model 1" "Model 2" "Model 3" "Model 4" "Model 5" "Model 6" "Model 7" "Model 8" "Model 9") onecell nogap, using GO_Final_Appendix_D2.rtf, replace title({\b Table D2.} {Likelihood of Dominant party winning})

**Appendix E - Urban-rural gmina (Poland only)**

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty dom_party_inc_cand urbanrural_dummy i.cycle_year if country==1
estimates store table5model1ur

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand urbanrural_dummy i.cycle_year if country==1
estimates store table5model4ur

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand urbanrural_dummy i.cycle_year 
estimates store table5model7ur

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty round_2##c.numbercand dom_party_inc_cand urbanrural_dummy i.cycle_year 
estimates store table5model8ur

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand urbanrural_dummy i.cycle_year if round_2==1
estimates store table5model9ur

esttab table5model1ur table5model4ur table5model7ur table5model8ur table5model9ur, compress coeflabels(unemployment_rate Unemployment numbercand Candidates percent_over_sixty Percent over Sixty logpop Population) se label nonumbers nodepvars mtitles("Model 1" "Model 4" "Model 7" "Model 8" "Model 9") onecell nogap, using GO_Final_Appendix_E.rtf, replace title({\b Table E.} {Likelihood of Dominant party winning})

*FIgures 3 and 4*

*set scheme s2mono
set scheme s1mono

label variable country "Country"
label values country countrylabel
label define countrylabel 1 "Poland" 2 "Hungary"

label variable round_2 "Race goes to a 2nd round?"
label values round_2 round_2label
label define round_2label 1 "Two-round Race" 0 "One-round Race"

label variable dom_party_inc_cand "Dominant-party incumbent in the race?"
label values dom_party_inc_cand dom_party_inc_candlabel
label define dom_party_inc_candlabel 1 "Dominant-party incumbent" 0 "No dominant-party incumbent"


**********Figures
* Figure 3 - (Models 4 & 5) Visualization of why we reject Hypothesis 1, i.e. lack of a statistically significant relationship between # of candidates and dom-party win.
* 	• First, Model 5 (Hungary)
xtlogit dom_party_overall_win c.logpop c.unemployment_rate c.percent_over_sixty c.numbercand i.dom_party_inc_cand i.cycle_year if country==2
margins, at(numbercand=(2(1)10))
marginsplot, title("Hungary") xtitle("Number of Candidates") ytitle("Predicted Probablity")
* 	• Second, Model 4 (Poland)
xtlogit dom_party_overall_win c.logpop c.unemployment_rate c.percent_over_sixty c.numbercand i.dom_party_inc_cand i.cycle_year if country==1
margins, at(numbercand=(2(1)10))
marginsplot, title("Poland") xtitle("Number of Candidates") ytitle("Predicted Probablity")

 
*Figure 4 - Shows expected probabilities by Number of Candidates, broken down by one round or two, Poland only (Model 8).
xtlogit dom_party_overall_win c.logpop c.unemployment_rate c.percent_over_sixty i.round_2##c.numbercand i.dom_party_inc_cand i.cycle_year 
margins round_2, at(numbercand=(3(1)10))
**Without Title Caption
marginsplot, xtitle("Number of Candidates") ytitle("Predicted Probablity")
**With Title Caption
*marginsplot, title("Figure 4: Predicted Probabilities of a Dominant-Party Win in Poland") subtitle("by number of Candidates and Round (with 95% confidence intervals)") xtitle("Number of Candidates") ytitle("Predicted Probablity")


*AIC/BIC*
xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.cycle_year i.country

estat ic

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand

estat ic

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.country

estat ic

xtlogit dom_party_overall_win logpop unemployment_rate percent_over_sixty numbercand dom_party_inc_cand i.year i.country

estat ic
